//=============================================================================
// MenuUIMessageBoxWindow a modified menu ive been screwing with
//=============================================================================

class MenuUIDrivingWindow expands MenuUIWindow;
	
// ----------------------------------------------------------------------
// Local Variables
// ----------------------------------------------------------------------

// Text Colors used by menus
var Color colTextMessage;

// Windows
var MenuUIHeaderWindow winText;
var MenuUIActionButtonWindow btnExit;
var MenuUIActionButtonWindow btnEject;
// Mode
var bool bDeferredKeyPress;
var bool bKeyPressed;

// Window to be notified when user makes a selection
var Window winNotify;

var int textBorderX;
var int textBorderY;
var int numButtons;

//added junk
var MSDrivables MSDrivable;
var DeusExPlayer _windowOwner;

// ----------------------------------------------------------------------
// InitWindow()
//
// Initialize the Window
// ----------------------------------------------------------------------

event InitWindow()
{
	Super.InitWindow();

	// Force the title bar to be a certain width;
	winTitle.minTitleWidth = 250;

	CreateTextWindow();
	SetTitle("Current Driving Stats");
	SetNotifyWindow(Self);
	btnExit  = winButtonBar.AddButton("Exit", HALIGN_Center);
	btnEject  = winButtonBar.AddButton("EjectPassenger", HALIGN_Right);
	SetFocusWindow(btnExit);
}

// ----------------------------------------------------------------------
// CreateTextWindow()
// ----------------------------------------------------------------------

function CreateTextWindow()
{
	winText = CreateMenuHeader(21, 13, "", winClient);
	winText.SetTextAlignments(HALIGN_Center, VALIGN_Center);
	winText.SetFont(Font'FontMenuHeaders_DS');
	winText.SetWindowAlignments(HALIGN_Center, VALIGN_Full, textBorderX, textBorderY);
}

// ----------------------------------------------------------------------
// SetMessageText()
//
// Sets the text displayed in the message box
// ----------------------------------------------------------------------

function SetMessageText( String msgText )
{
	winText.SetText(msgText);

	AskParentForReconfigure();
}

// ----------------------------------------------------------------------
// SetDeferredKeyPress()
// ----------------------------------------------------------------------

function SetDeferredKeyPress(bool bNewDeferredKeyPress)
{
	bDeferredKeyPress = bNewDeferredKeyPress;
}

function bool ButtonActivated( Window buttonPressed )
{
	local bool bHandled;

	bHandled = True;

	Super.ButtonActivated(buttonPressed);

	switch( buttonPressed )
	{
		case btnExit:
			if ((bDeferredKeyPress) && (IsKeyDown(IK_Escape)))
				bKeyPressed = True;
			else

                        if (!MSDrivable.IsInState('MSDriving2'))
                        {
				MSDrivable.StopMSDriving();
                                root.PopWindow();
			}
			bHandled = True;
			break;

		case btnEject:
			if ((bDeferredKeyPress) && (IsKeyDown(IK_Enter)))
				bKeyPressed = True;
			else
				MSDrivable.EjectPassenger();

			bHandled = True;
			break;

		default:
			bHandled = False;
			break;
	}

	return bHandled;
}

/*event bool MouseButtonReleased(float pointX, float pointY, EInputKey button, int numClicks)
{
	return True;
}*/

// ----------------------------------------------------------------------
// SetNotifyWindow()
// ----------------------------------------------------------------------

function SetNotifyWindow( Window newWinNotify )
{
	winNotify = newWinNotify;
}

//virtual key pressed crap
event bool VirtualKeyPressed(EInputKey key, bool bRepeat)
{
	local bool bHandled;

	switch( key ) 
	{
		case IK_Escape:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.StopMSDriving();
                        root.PopWindow();
                        bHandled = True;
                        break;
                case IK_W:
                case IK_Up:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.MSDriveForward();
                        bHandled = True;
                        break;
                case IK_S:
                case IK_Down:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.MSDriveBackward();
                        bHandled = True;
                        break;
                case IK_A:
                case IK_Left:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.MSTurnLeft();
                        bHandled = True;
                        break;
                case IK_D:
                case IK_Right:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.MSTurnRight();
                        bHandled = True;
                        break;
                case IK_Space:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.MSBrake();
                        bHandled = True;
                        break;
                case IK_1:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
			if ((MSDrivable.MSCarDriver.Credits >= MSDrivable.CarSpeed * 50) && (MSDrivable.CarSpeed < 10))
             		{
                		MSDrivable.MSCarDriver.Credits -= MSDrivable.CarSpeed * 50;
                    		MSDrivable.CarSpeed += 1;
                	}
                        bHandled = True;
                        break;
                case IK_2:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
			if ((MSDrivable.MSCarDriver.Credits >= MSDrivable.MSAccelerationSpeed * 50) && (MSDrivable.MSAccelerationSpeed < 10))
             		{
                		MSDrivable.MSCarDriver.Credits -= MSDrivable.MSAccelerationSpeed * 50;
                    		MSDrivable.MSAccelerationSpeed += 1;
                	}
                        bHandled = True;
                        break;
                case IK_3:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
			if ((MSDrivable.MSCarDriver.Credits >= MSDrivable.TopGas * 50) && (MSDrivable.TopGas < 10))
             		{
                		MSDrivable.MSCarDriver.Credits -= MSDrivable.TopGas * 50;
                    		MSDrivable.TopGas += 1;
                	}
                        bHandled = True;
                        break;
                case IK_4:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
			if ((MSDrivable.MSCarDriver.Credits >= MSDrivable.BrakeStrength * 50) && (MSDrivable.BrakeStrength < 10))
             		{
                		MSDrivable.MSCarDriver.Credits -= MSDrivable.BrakeStrength * 50;
                    		MSDrivable.BrakeStrength += 1;
                	}
                        bHandled = True;
                        break;
                case IK_5:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
			if (MSDrivable.LeftGun != None)
             		{
                		MSDrivable.LeftGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
			if (MSDrivable.RightGun != None)
             		{
                		MSDrivable.RightGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
		       if (MSDrivable.MSCarDriver.Credits >= 100)
             	       {
                        MSDrivable.LeftGun = MSDrivable.Spawn(class'DrivableWeaponAssaultGun', MSDrivable,, MSDrivable.Location);
                        MSDrivable.LeftGun.AttachedTo = MSDrivable;
                        MSDrivable.RightGun = MSDrivable.Spawn(class'DrivableWeaponAssaultGun', MSDrivable,, MSDrivable.Location);
                        MSDrivable.RightGun.AttachedTo = MSDrivable;
                        MSDrivable.MSCarDriver.Credits -= 100;
                       }
                        bHandled = True;
                        break;
                case IK_6:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
			if (MSDrivable.LeftGun != None)
             		{
                		MSDrivable.LeftGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
			if (MSDrivable.RightGun != None)
             		{
                		MSDrivable.RightGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
		       if (MSDrivable.MSCarDriver.Credits >= 100)
             	       {
                        MSDrivable.LeftGun = MSDrivable.Spawn(class'DrivableWeaponAssaultShotgun', MSDrivable,, MSDrivable.Location);
                        MSDrivable.LeftGun.AttachedTo = MSDrivable;
                        MSDrivable.RightGun = MSDrivable.Spawn(class'DrivableWeaponAssaultShotgun', MSDrivable,, MSDrivable.Location);
                        MSDrivable.RightGun.AttachedTo = MSDrivable;
                        MSDrivable.MSCarDriver.Credits -= 100;
                       }
                        bHandled = True;
                        break;
                case IK_7:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
			if (MSDrivable.LeftGun != None)
             		{
                		MSDrivable.LeftGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
			if (MSDrivable.RightGun != None)
             		{
                		MSDrivable.RightGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
		       if (MSDrivable.MSCarDriver.Credits >= 100)
             	       {
                        MSDrivable.LeftGun = MSDrivable.Spawn(class'DrivableWeaponRPG', MSDrivable,, MSDrivable.Location);
                        MSDrivable.LeftGun.AttachedTo = MSDrivable;
                        MSDrivable.RightGun = MSDrivable.Spawn(class'DrivableWeaponRPG', MSDrivable,, MSDrivable.Location);
                        MSDrivable.RightGun.AttachedTo = MSDrivable;
                        MSDrivable.MSCarDriver.Credits -= 100;
                       }
                        bHandled = True;
                        break;
                case IK_8:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
			if (MSDrivable.LeftGun != None)
             		{
                		MSDrivable.LeftGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
			if (MSDrivable.RightGun != None)
             		{
                		MSDrivable.RightGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
		       if (MSDrivable.MSCarDriver.Credits >= 100)
             	       {
                        MSDrivable.LeftGun = MSDrivable.Spawn(class'DrivableWeaponRepeater', MSDrivable,, MSDrivable.Location);
                        MSDrivable.LeftGun.AttachedTo = MSDrivable;
                        MSDrivable.RightGun = MSDrivable.Spawn(class'DrivableWeaponRepeater', MSDrivable,, MSDrivable.Location);
                        MSDrivable.RightGun.AttachedTo = MSDrivable;
                        MSDrivable.MSCarDriver.Credits -= 100;
                       }
                        bHandled = True;
                        break;
                case IK_Enter:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.EjectPassenger();
                        bHandled = True;
                        break;
                case IK_Q:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.LeftGun.Fire();
                        MSDrivable.RightGun.Fire();
                        bHandled = True;
                        break;
                case IK_E:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.EBrakeTimer += 0.65;
                        bHandled = True;
                        break;
                case IK_LeftBracket:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.AimDown();
                        bHandled = True;
                        break;
                case IK_RightBracket:
			if (bDeferredKeyPress) 
				bKeyPressed = True;
                        MSDrivable.AimUp();
                        bHandled = True;
                        break;
	}

	return bHandled;
}

// ----------------------------------------------------------------------
// RawKeyPressed()
// ----------------------------------------------------------------------

event bool RawKeyPressed(EInputKey key, EInputState iState, bool bRepeat)
{
	if (((key == IK_W) || (key == IK_Up)) && (bKeyPressed))
	{
                MSDrivable.MSDriveForward();
                return true;
	}
	if (((key == IK_S) || (key == IK_Down)) && (bKeyPressed))
	{
                MSDrivable.MSDriveBackward();
                return true;
	}
	if (((key == IK_A) || (key == IK_Left)) && (bKeyPressed)) //turn to the left
	{
		MSDrivable.MSTurnLeft();
                return true;
        }
	if (((key == IK_D) || (key == IK_Right)) && (bKeyPressed)) //turn to the right
	{
		MSDrivable.MSTurnRight();
                return true;
        }
	if ((key == IK_Space) && (bKeyPressed)) //brakes control
	{
		MSDrivable.MSBrake();
                return true;
        }
	if ((key == IK_1) && (bKeyPressed)) //upgrade stat 1
	{
		if (MSDrivable.MSCarDriver.Credits >= MSDrivable.CarSpeed * 50)
                {
                    MSDrivable.MSCarDriver.Credits -= MSDrivable.CarSpeed * 50;
                    MSDrivable.CarSpeed += 1;
                }
                return true;
        }
	if ((key == IK_2) && (bKeyPressed)) //upgrade stat 2
	{
		if (MSDrivable.MSCarDriver.Credits >= MSDrivable.MSAccelerationSpeed * 50)
                {
                    MSDrivable.MSCarDriver.Credits -= MSDrivable.MSAccelerationSpeed * 50;
                    MSDrivable.MSAccelerationSpeed += 1;
                }
                return true;
        }
	if ((key == IK_3) && (bKeyPressed)) //upgrade stat 3
	{
		if (MSDrivable.MSCarDriver.Credits >= MSDrivable.TopGas * 50)
                {
                    MSDrivable.MSCarDriver.Credits -= MSDrivable.TopGas * 50;
                    MSDrivable.TopGas += 1;
                }
                return true;
        }
	if ((key == IK_4) && (bKeyPressed)) //upgrade stat 4
	{
		if (MSDrivable.MSCarDriver.Credits >= MSDrivable.BrakeStrength * 50)
                {
                    MSDrivable.MSCarDriver.Credits -= MSDrivable.BrakeStrength * 50;
                    MSDrivable.BrakeStrength += 1;
                }
                return true;
        }
	if ((key == IK_Enter) && (bKeyPressed)) //eject passenger button lol
	{
                MSDrivable.EjectPassenger();
                return true;
        }
        if ((key == IK_5) && (bKeyPressed))
        {
			if (MSDrivable.LeftGun != None)
             		{
                		MSDrivable.LeftGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
			if (MSDrivable.RightGun != None)
             		{
                		MSDrivable.RightGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
		       if (MSDrivable.MSCarDriver.Credits >= 100)
             	       {
                        MSDrivable.LeftGun = MSDrivable.Spawn(class'DrivableWeaponAssaultGun', MSDrivable,, MSDrivable.Location);
                        MSDrivable.LeftGun.AttachedTo = MSDrivable;
                        MSDrivable.RightGun = MSDrivable.Spawn(class'DrivableWeaponAssaultGun', MSDrivable,, MSDrivable.Location);
                        MSDrivable.RightGun.AttachedTo = MSDrivable;
                        MSDrivable.MSCarDriver.Credits -= 100;
                       }
                       return True;
        }
        if ((key == IK_6) && (bKeyPressed))
        {
			if (MSDrivable.LeftGun != None)
             		{
                		MSDrivable.LeftGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
			if (MSDrivable.RightGun != None)
             		{
                		MSDrivable.RightGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
		       if (MSDrivable.MSCarDriver.Credits >= 100)
             	       {
                        MSDrivable.LeftGun = MSDrivable.Spawn(class'DrivableWeaponAssaultShotgun', MSDrivable,, MSDrivable.Location);
                        MSDrivable.LeftGun.AttachedTo = MSDrivable;
                        MSDrivable.RightGun = MSDrivable.Spawn(class'DrivableWeaponAssaultShotgun', MSDrivable,, MSDrivable.Location);
                        MSDrivable.RightGun.AttachedTo = MSDrivable;
                        MSDrivable.MSCarDriver.Credits -= 100;
                       }
                       return True;
        }
        if ((key == IK_7) && (bKeyPressed))
        {
			if (MSDrivable.LeftGun != None)
             		{
                		MSDrivable.LeftGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
			if (MSDrivable.RightGun != None)
             		{
                		MSDrivable.RightGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
		       if (MSDrivable.MSCarDriver.Credits >= 100)
             	       {
                        MSDrivable.LeftGun = MSDrivable.Spawn(class'DrivableWeaponRPG', MSDrivable,, MSDrivable.Location);
                        MSDrivable.LeftGun.AttachedTo = MSDrivable;
                        MSDrivable.RightGun = MSDrivable.Spawn(class'DrivableWeaponRPG', MSDrivable,, MSDrivable.Location);
                        MSDrivable.RightGun.AttachedTo = MSDrivable;
                        MSDrivable.MSCarDriver.Credits -= 100;
                       }
                       return True;
        }
        if ((key == IK_8) && (bKeyPressed))
        {
			if (MSDrivable.LeftGun != None)
             		{
                		MSDrivable.LeftGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
			if (MSDrivable.RightGun != None)
             		{
                		MSDrivable.RightGun.Destroy();
                                MSDrivable.MSCarDriver.Credits += 50;
                	}
		       if (MSDrivable.MSCarDriver.Credits >= 100)
             	       {
                        MSDrivable.LeftGun = MSDrivable.Spawn(class'DrivableWeaponRepeater', MSDrivable,, MSDrivable.Location);
                        MSDrivable.LeftGun.AttachedTo = MSDrivable;
                        MSDrivable.RightGun = MSDrivable.Spawn(class'DrivableWeaponRepeater', MSDrivable,, MSDrivable.Location);
                        MSDrivable.RightGun.AttachedTo = MSDrivable;
                        MSDrivable.MSCarDriver.Credits -= 100;
                       }
                       return True;
        }
        if ((key == IK_Q) && (bKeyPressed))
        {
                        MSDrivable.LeftGun.Fire();
                        MSDrivable.RightGun.Fire();
                        return True;
        }
        if ((key == IK_E) && (bKeyPressed))
        {
                        MSDrivable.EBrakeTimer += 0.65;
                        return True;
        }
	else
	{
		return false;  // don't handle
	}
}

// ----------------------------------------------------------------------
// refresh window crap, closest thing to tick they got...
// ----------------------------------------------------------------------

function RefreshWindow(float DeltaTime)
{
 if (MSDrivable != None)
  SetMessageText(MSDrivable.GetDrivingStats());

 Super.RefreshWindow(DeltaTime);
}

defaultproperties
{
     textBorderX=20
     textBorderY=14
     ClientWidth=280
     ClientHeight=85
     clientTextures(0)=Texture'DeusExUI.UserInterface.MenuMessageBoxBackground_1'
     clientTextures(1)=Texture'DeusExUI.UserInterface.MenuMessageBoxBackground_2'
     textureRows=1
     textureCols=2
     bActionButtonBarActive=True
     bUsesHelpWindow=False
     winShadowClass=Class'DeusEx.MenuUIMessageBoxShadowWindow'
}